
package cn.smarthse.radiationTraining.modules.sys.entity.sys;

import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 *
 * 个人、企业消息
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/21 13:54
 */
@EqualsAndHashCode(callSuper = true)
@TableName("sys_msg")
public @Data class SysMsg extends BaseBean {

	private static final long serialVersionUID = -3554332123718496392L;

	@TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	/**
	 * 账号id（个人or企业）
	 */
	private Long userId;
	/**
	 * 消息分类 MsgTypeEnum
	 */
	private String msgType;
	/**
	 * 推送时间
	 */
	private Date pushTime;
	/**
	 * 内容
	 */
	private String content;
	/**
	 * 链接
	 */
	private String url;
	/**
	 * 是否已读（1:已读；0：未读）
	 */
	private Boolean isRead;
	/**
	 * 阅读时间
	 */
	private Date readTime;
}
