package cn.smarthse.radiationTraining.modules.sys.entity.sys;

import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 文件表
 * </p>
 *
 * @author denglibin
 * @since 2020-08-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
//@ApiModel(value="SysFile对象", description="文件表")
public class SysFile extends BaseBean {

    private static final long serialVersionUID = 3428837577482017491L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    //@ApiModelProperty(value = "OSS路径地址（相对）")
    private String ossUrl;

    //@ApiModelProperty(value = "附件名")
    private String fileName;

    //@ApiModelProperty(value = "附件大小")
    private String fileSize;

    //@ApiModelProperty(value = "附件扩展名（可用于图标展示）")
    private String fileExt;

    //@ApiModelProperty(value = "附件Hash")
    private String fileHash;

    //@ApiModelProperty(value = "上传IP")
    private String creatorIp;

    @TableField(exist = false)
    private String fullOssUrl;

}
