package cn.smarthse.radiationTraining.modules.sys.entity.sys;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * app版本表
 * @TableName sys_app_version
 */
@Data
@TableName("sys_app_version")
public class SysAppVersion implements Serializable {
    /**
     * ID
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 版本X.Y.Z
     */
    private String version;
    private Integer versionX;
    private Integer versionY;
    private Integer versionZ;

    /**
     * 软件类型(0安卓1苹果)
     */
    private Integer type;

    /**
     * 日志内容
     */
    private String content;

    /**
     * 是否显示日志(0否1是)
     */
    private Integer ifShow;

    /**
     * 0不需要更新 1可更新 2强制更新
     */
    private Integer updateType;

    /**
     * 发布时间
     */
    private Date releaseTime;

    /**
     * url
     */
    private String url;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 更新人
     */
    private Long updateBy;

    /**
     * 是否有效(0-无效；1-有效)
     */
    private Integer isValid;

}