package cn.smarthse.radiationTraining.modules.sys.entity.order;

import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单退款记录
 *
 * @author wuxq
 * @since 2025年5月19日 下午1:34:15
 */
@EqualsAndHashCode(callSuper = true)
@TableName(value = "sys_order_refund")
public @Data class SysOrderRefund extends BaseBean {

    private static final long serialVersionUID = 1L;

//    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 关联用户id（企业账单，全额退款时，此字段为企业用户id，其他均为个人用户id）
     */
    private Long userId;
    /**
     * 订单id
     */
    private Long orderId;
    /**
     * 微信or支付宝订单号
     */
    private String orderNo;
    /**
     * 三方支付方式 OrderThirdPayTypeEnum(微信支付-1; 支付宝支付-2)
     */
    private Integer thirdPayType;
    /**
     * 退款状态(1-成功; 2-失败/异常)
     */
    private Integer state;
    /**
     * 原订单金额/元
     */
    private BigDecimal totalAmount;
    /**
     * 退款金额/元
     */
    private BigDecimal refundAmount;
    /**
     * 退款申请通过时间（冗余）
     */
    private Date refundPassTime;
    /**
     * 退款申请失败时间（冗余）
     */
    private Date refundFailTime;
}
