package cn.smarthse.radiationTraining.modules.sys.entity.order;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单
 *
 * @author wuxq
 * @since 2025年5月19日 下午1:34:15
 */
@EqualsAndHashCode(callSuper = true)
@TableName(value = "sys_order")
public @Data class SysOrder extends BaseBean {

    private static final long serialVersionUID = 1L;

    //	@ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 关联账号id
     */
    private Long userId;
    /**
     * 业务id
     */
    private Long businessId;
    /**
     * 关联账号
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String username;
    /**
     * 用户姓名
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    private String nickname;
    /**
     * 关联商品id
     */
    private Long goodsId;
    /**
     * 订单号
     */
    private String orderNo;
    /**
     * 订单号
     */
    private Integer orderType;
    /**
     * 三方支付方式 OrderThirdPayTypeEnum(微信支付-1; 支付宝支付-2)
     */
    private Integer thirdPayType;
    /**
     * 付费类型(1-线上支付; 2-线下支付；3-赠送)
     */
    private Integer payType;
    /**
     * 支付状态：1-未支付（待支付）；2-已支付；3-取消（线上超时未支付后取消;）4-已退款; 5-申请退款
     */
    private Integer payState;
    /**
     * 支付时间
     */
    private Date payDate;
    /**
     * 订单标题
     */
    private String subject;
    /**
     * 商品单价（培训单价）
     */
    private BigDecimal unitPrice;
    /**
     * 商品数量（报名人数）
     */
    private Integer quantity;
    /**
     * 商品总额
     */
    private BigDecimal goodsPrice;
    /**
     * 实付款
     */
    private BigDecimal payMoney;
    /**
     * 备注
     */
    private String remarks;

}
