package cn.smarthse.radiationTraining.modules.sys.entity.order;

import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 
 * 套餐
 * 
 * @author wuxq
 * @since 2025年5月19日 下午1:34:15
 */
@EqualsAndHashCode(callSuper = true)
@TableName(value = "sys_combo")
public @Data class SysCombo extends BaseBean {
	
	private static final long serialVersionUID = 1L;

//	@ApiModelProperty("ID")
	@TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;

	/**
	 * 套餐名称
	 */
	private String name;
	/**
	 * 类型(1-会员开通、2-会员续费、3-商务合作-签约、4-商务合作-续签、5-职业健康管理员报名、6-培训资源下载)
	 */
	private Integer type;
	/**
	 * 套餐价格
	 */
	private BigDecimal price;
	/**
	 * 下次套餐价格
	 */
	private BigDecimal nextPrice;
	/**
	 * 套餐有效时长/月
	 */
	private Integer validMonth;
	/**
	 * 套餐详情说明
	 */
	private String remark;
}
