package cn.smarthse.radiationTraining.modules.sys.entity.hse;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 四级行业
 *
 * @TableName industry
 */
@TableName(value = "industry")
@Accessors(chain = true)
@Data
public class HseIndustry implements Serializable {
    /**
     * id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 父id
     */
    private Long pid;

    /**
     * 行业编码
     */
    private String code;

    /**
     * 父行业编码
     */
    private String pcode;

    /**
     * 名称
     */
    private String name;

    /**
     * 行业编码【用于兼容一些同一个编码，但有多个行业的情况】
     */
    private String subCode;

    /**
     * 行业级别从1开始
     */
    private Integer level;

    /**
     * 是否是叶子节点(0:不是; 1:是)
     */
    private Integer isLeaf;

    /**
     * 一级行业编码
     */
    private String industryCode1;

    /**
     * 二级行业编码
     */
    private String industryCode2;

    /**
     * 三级行业编码
     */
    private String industryCode3;

    /**
     * 四级行业编码
     */
    private String industryCode4;

    /**
     * 一级行业
     */
    private String industryName1;

    /**
     * 二级行业
     */
    private String industryName2;

    /**
     * 三级行业
     */
    private String industryName3;

    /**
     * 四级行业
     */
    private String industryName4;

    /**
     * 描述
     */
    private String description;

    /**
     * 危害程度(严重 -WHCDS  一般-WHCDC 未划分-WHF 未细分-WXF)
     */
    private String harmLevel;

    /**
     * 行业类型标记（0: 默认, 无实际含义; 1: 重点行业1-冶金; 2-矿山; 3-化工; 4-建材; 5,6,7...可拓展）
     */
    private Integer industryType;

    /**
     * 同节点下行业排序(默认为id值)
     */
    private Long sort;

    /**
     * 查询热度
     */
    private Long hot;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 是否有效
     */
    private Integer isValid;

    /**
     *
     */
    private String classA;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        HseIndustry other = (HseIndustry) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
                && (this.getPid() == null ? other.getPid() == null : this.getPid().equals(other.getPid()))
                && (this.getCode() == null ? other.getCode() == null : this.getCode().equals(other.getCode()))
                && (this.getPcode() == null ? other.getPcode() == null : this.getPcode().equals(other.getPcode()))
                && (this.getName() == null ? other.getName() == null : this.getName().equals(other.getName()))
                && (this.getLevel() == null ? other.getLevel() == null : this.getLevel().equals(other.getLevel()))
                && (this.getIsLeaf() == null ? other.getIsLeaf() == null : this.getIsLeaf().equals(other.getIsLeaf()))
                && (this.getIndustryCode1() == null ? other.getIndustryCode1() == null : this.getIndustryCode1().equals(other.getIndustryCode1()))
                && (this.getIndustryCode2() == null ? other.getIndustryCode2() == null : this.getIndustryCode2().equals(other.getIndustryCode2()))
                && (this.getIndustryCode3() == null ? other.getIndustryCode3() == null : this.getIndustryCode3().equals(other.getIndustryCode3()))
                && (this.getIndustryCode4() == null ? other.getIndustryCode4() == null : this.getIndustryCode4().equals(other.getIndustryCode4()))
                && (this.getIndustryName1() == null ? other.getIndustryName1() == null : this.getIndustryName1().equals(other.getIndustryName1()))
                && (this.getIndustryName2() == null ? other.getIndustryName2() == null : this.getIndustryName2().equals(other.getIndustryName2()))
                && (this.getIndustryName3() == null ? other.getIndustryName3() == null : this.getIndustryName3().equals(other.getIndustryName3()))
                && (this.getIndustryName4() == null ? other.getIndustryName4() == null : this.getIndustryName4().equals(other.getIndustryName4()))
                && (this.getDescription() == null ? other.getDescription() == null : this.getDescription().equals(other.getDescription()))
                && (this.getHarmLevel() == null ? other.getHarmLevel() == null : this.getHarmLevel().equals(other.getHarmLevel()))
                && (this.getIndustryType() == null ? other.getIndustryType() == null : this.getIndustryType().equals(other.getIndustryType()))
                && (this.getSort() == null ? other.getSort() == null : this.getSort().equals(other.getSort()))
                && (this.getHot() == null ? other.getHot() == null : this.getHot().equals(other.getHot()))
                && (this.getCreateBy() == null ? other.getCreateBy() == null : this.getCreateBy().equals(other.getCreateBy()))
                && (this.getCreateDate() == null ? other.getCreateDate() == null : this.getCreateDate().equals(other.getCreateDate()))
                && (this.getUpdateBy() == null ? other.getUpdateBy() == null : this.getUpdateBy().equals(other.getUpdateBy()))
                && (this.getUpdateDate() == null ? other.getUpdateDate() == null : this.getUpdateDate().equals(other.getUpdateDate()))
                && (this.getIsValid() == null ? other.getIsValid() == null : this.getIsValid().equals(other.getIsValid()))
                && (this.getClassA() == null ? other.getClassA() == null : this.getClassA().equals(other.getClassA()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getPid() == null) ? 0 : getPid().hashCode());
        result = prime * result + ((getCode() == null) ? 0 : getCode().hashCode());
        result = prime * result + ((getPcode() == null) ? 0 : getPcode().hashCode());
        result = prime * result + ((getName() == null) ? 0 : getName().hashCode());
        result = prime * result + ((getLevel() == null) ? 0 : getLevel().hashCode());
        result = prime * result + ((getIsLeaf() == null) ? 0 : getIsLeaf().hashCode());
        result = prime * result + ((getIndustryCode1() == null) ? 0 : getIndustryCode1().hashCode());
        result = prime * result + ((getIndustryCode2() == null) ? 0 : getIndustryCode2().hashCode());
        result = prime * result + ((getIndustryCode3() == null) ? 0 : getIndustryCode3().hashCode());
        result = prime * result + ((getIndustryCode4() == null) ? 0 : getIndustryCode4().hashCode());
        result = prime * result + ((getIndustryName1() == null) ? 0 : getIndustryName1().hashCode());
        result = prime * result + ((getIndustryName2() == null) ? 0 : getIndustryName2().hashCode());
        result = prime * result + ((getIndustryName3() == null) ? 0 : getIndustryName3().hashCode());
        result = prime * result + ((getIndustryName4() == null) ? 0 : getIndustryName4().hashCode());
        result = prime * result + ((getDescription() == null) ? 0 : getDescription().hashCode());
        result = prime * result + ((getHarmLevel() == null) ? 0 : getHarmLevel().hashCode());
        result = prime * result + ((getIndustryType() == null) ? 0 : getIndustryType().hashCode());
        result = prime * result + ((getSort() == null) ? 0 : getSort().hashCode());
        result = prime * result + ((getHot() == null) ? 0 : getHot().hashCode());
        result = prime * result + ((getCreateBy() == null) ? 0 : getCreateBy().hashCode());
        result = prime * result + ((getCreateDate() == null) ? 0 : getCreateDate().hashCode());
        result = prime * result + ((getUpdateBy() == null) ? 0 : getUpdateBy().hashCode());
        result = prime * result + ((getUpdateDate() == null) ? 0 : getUpdateDate().hashCode());
        result = prime * result + ((getIsValid() == null) ? 0 : getIsValid().hashCode());
        result = prime * result + ((getClassA() == null) ? 0 : getClassA().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", pid=").append(pid);
        sb.append(", code=").append(code);
        sb.append(", pcode=").append(pcode);
        sb.append(", name=").append(name);
        sb.append(", level=").append(level);
        sb.append(", isLeaf=").append(isLeaf);
        sb.append(", industryCode1=").append(industryCode1);
        sb.append(", industryCode2=").append(industryCode2);
        sb.append(", industryCode3=").append(industryCode3);
        sb.append(", industryCode4=").append(industryCode4);
        sb.append(", industryName1=").append(industryName1);
        sb.append(", industryName2=").append(industryName2);
        sb.append(", industryName3=").append(industryName3);
        sb.append(", industryName4=").append(industryName4);
        sb.append(", description=").append(description);
        sb.append(", harmLevel=").append(harmLevel);
        sb.append(", industryType=").append(industryType);
        sb.append(", sort=").append(sort);
        sb.append(", hot=").append(hot);
        sb.append(", createBy=").append(createBy);
        sb.append(", createDate=").append(createDate);
        sb.append(", updateBy=").append(updateBy);
        sb.append(", updateDate=").append(updateDate);
        sb.append(", isValid=").append(isValid);
        sb.append(", classA=").append(classA);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}