package cn.smarthse.radiationTraining.modules.sys.entity;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 *
 *  操作日志
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/7 16:20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@TableName("sys_log")
public class SysLog extends BaseBean {

    private static final long serialVersionUID = 1L;

    //@ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    //@ApiModelProperty("账号id")
    @TableField("user_id")
    private Long userId;

    //@ApiModelProperty("操作账号(冗余)")
    @TableField("username")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String username;

    //@ApiModelProperty("用户姓名(冗余)")
    @TableField("fullname")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String fullname;

    //@ApiModelProperty("行政区划")
    @TableField("area_id")
    private Long areaId;

    //@ApiModelProperty("日志标题")
    @TableField("title")
    private String title;

    //@ApiModelProperty("来源（1-admin；2-www；3-wx）")
    @TableField("resource")
    private Integer resource;

    //@ApiModelProperty("模块（LogModuleTypeEnum）")
    @TableField("module_type")
    private Integer moduleType;

    //@ApiModelProperty("类型（LogTypeEnum）")
    @TableField("type")
    private Integer type;

    //@ApiModelProperty("请求IP地址")
    @TableField("remote_ip")
    private String remoteIp;

    //@ApiModelProperty("用户代理信息")
    @TableField("user_agent")
    private String userAgent;

    //@ApiModelProperty("请求URI")
    @TableField("request_uri")
    private String requestUri;

    //@ApiModelProperty("操作方式、post/get/push等resetful")
    @TableField("request_method")
    private String requestMethod;

    //@ApiModelProperty("操作提交的数据内容(json)或者异常信息")
    @TableField("params")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String params;
}
