package cn.smarthse.radiationTraining.modules.sys.vo.web.vo;

import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFileVo;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * 文章列-资讯详情vo
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/11 9:36
 */
@Data
public class ArticleApiVo implements Serializable {

    private static final long serialVersionUID = -4421573122803499934L;

    private Long id;

    @ApiModelProperty("主题名称")
    private String title;

    @ApiModelProperty("简介")
    private String summary;

    @ApiModelProperty("正文内容")
    private String content;

    @ApiModelProperty("文章类型：0101-通知公告；0102-信息资讯；0103-政策解读；0104-企业抗疫")
    private String type;

    @ApiModelProperty("封面图链接")
    private String imageUrl;

    @ApiModelProperty("是否置顶（1-置顶；0-不置顶）")
    private Integer isTop;

    @ApiModelProperty("点击量")
    private Integer clicks;

    @ApiModelProperty("状态：0-草稿；1-下架；2-上架；")
    private Integer state;

    @ApiModelProperty("来源")
    private String resource;

    @ApiModelProperty("发布时间")
    private String releaseDate;

    @ApiModelProperty("发布人")
    private String releaser;

    @ApiModelProperty("附件")
    List<SysFileVo> files;

    @ApiModelProperty("上一篇")
    private ArticleTurnPage last;

    @ApiModelProperty("下一篇")
    private ArticleTurnPage next;
}
