package cn.smarthse.radiationTraining.modules.sys.vo.user.info;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Data;

/**
 * 单位底库-列表
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/17 11:03
 */
@ApiModel
@Data
public class CompanyListVo implements Serializable {

    private static final long serialVersionUID = 4144562280100304016L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("单位名称")
    private String name;

    @ApiModelProperty("区域id")
    private Long areaId;

    @ApiModelProperty("直属企业类型(0:非直属;1:省直属;2:市属)")
    private Integer belongType;

    @ApiModelProperty("社会信用代码")
    private String creditCode;

    @ApiModelProperty("注册地址-详细")
    private String address;

    @ApiModelProperty("注册地址-行政区划")
    private String areaAddress;

    @ApiModelProperty("完整地址")
    private String fullAddress;

    @ApiModelProperty("注册来源（1-导入、2-单位用户、3-个人用户）")
    private String resource;

    @ApiModelProperty("创建时间")
    private LocalDateTime createDate;

    @ApiModelProperty("是否有反馈信息0-无 1-有")
    private Integer hasFeedback;
}
