package cn.smarthse.radiationTraining.modules.sys.vo.user.info;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import java.io.Serializable;
import lombok.Data;

/**
 * 单位底库-导出列表
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/17 11:03
 */
@HeadRowHeight(20)
@ContentRowHeight(20)
@ColumnWidth(25)
@Data
public class CompanyExportListVo implements Serializable {

    private static final long serialVersionUID = 4144562280100304016L;

    @ExcelProperty("单位名称")
    private String name;

    @ExcelProperty("社会信用代码")
    private String creditCode;

    @ExcelProperty("完整地址")
    private String fullAddress;

    @ExcelIgnore
    @ExcelProperty("注册来源（1-导入、2-单位用户、3-个人用户）")
    private Integer resource = 1;

    @ExcelProperty("注册来源")
    private String resourceName;

    @ExcelProperty(value = "创建时间")
    private String createDate;

    public String getResourceName() {

        return resource == 1 ? "导入" : (resource == 2 ? "单位用户" : "个人用户");
    }
}
