package cn.smarthse.radiationTraining.modules.sys.vo.sys;

import cn.smarthse.radiationTraining.modules.sys.enums.sys.MsgTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 *
 * 消息体vo
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/21 14:27
 */
@Data
public class MsgVo implements Serializable {

    @ApiModelProperty(value = "消息id")
    private Long id;

    @ApiModelProperty(value = "消息分类(以MsgTypeEnum为准)")
    private String msgType;

    @ApiModelProperty(value = "推送时间")
    private Date pushTime;

    @ApiModelProperty(value = "内容")
    private String content;

    @ApiModelProperty(value = "链接")
    private String url;

    @ApiModelProperty(value = "是否已读（1:已读；0：未读）")
    private Boolean isRead;

    @ApiModelProperty(value = "阅读时间")
    private Date readTime;

    public String getMsgTypeStr() {
        return MsgTypeEnum.getMsgTypeEnum(this.msgType).getName();
    }
}
