package cn.smarthse.radiationTraining.modules.sys.vo.order;

import cn.smarthse.radiationTraining.core.framework.config.desensitization.Desensitization;
import cn.smarthse.radiationTraining.core.framework.config.desensitization.DesensitizationType;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单详情
 *
 * @author wuxq
 * @since 2025年5月19日 下午1:34:15
 */
@Data
public class SysOrderDetailModel implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 系统订单号
     */
    private Long id;

    /**
     * 微信支付宝订单号
     */
    private String orderNo;

    /**
     * 受训人id
     */
    private Long userId;

    /**
     * 受训人
     */
    @Desensitization(type = DesensitizationType.CHINESE_NAME)
    private String nickname;

    /**
     * 受训人手机号
     */
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String phoneNumber;

    /**
     * 受训人身份证号
     */
    @Desensitization(type = DesensitizationType.ID_CARD)
    private String idCard;

    /**
     * 受训人所在单位
     */
    private String companyName;

    /**
     * 培训名称
     */
    private String trainName;

    /**
     * 培训封面图片
     */
    private String trainCoverUrl;

    /**
     * 培训时间
     */
    private String trainTime;

    /**
     * 是否开始考试（0-否 1-是）
     */
    private Integer hasBegunTest;

    /**
     * 开始考试时间
     */
    private String startExamTime;

    /**
     * 下单时间
     */
    private Date createDate;

    /**
     * 下单时间
     */
    private Date payDate;

    /**
     * 实付款
     */
    private BigDecimal payMoney;

    /**
     * 支付状态：1-未支付（待支付）；2-已支付；3-取消（线上超时未支付后取消;）4-已退款; 5-申请退款
     */
    private Integer payState;

}
