
package cn.smarthse.radiationTraining.modules.sys.service.user;

import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.entity.user.UserLoginWeixin;
import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 第三方微信信息，由微信登录后获取
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年12月21日 下午4:32:29
 */
public interface IUserLoginWeixinService extends IService<UserLoginWeixin> {

	/**
	 * 根据openid查询
	 * @author liaoly
	 * @date 2020年12月21日 下午4:35:47
	 * @param openid
	 * @return UserLoginWeixin
	 */
	UserLoginWeixin getByOpenId(String openid);
	
	/**
	 * 根据unionid查询
	 * @author liaoly
	 * @date 2020年12月21日 下午4:35:47
	 * @param unionid
	 * @return UserLoginWeixin
	 */
	UserLoginWeixin getByUnionid(String unionid);
	
	/**
	 * 更新微信信息(根据openid查询，没查询到则insert(默认User.resource为UserResourceEnum.wechat_login_3)，查询到了则update),会添加or更新user
	 * @author liaoly
	 * @date 2020年12月21日 下午5:01:15
	 * @param userLoginWeixin
	 * @return SysUser 成功返回User，失败返回null
	 */
	public SysUser saveUserLoginWeixin(UserLoginWeixin userLoginWeixin);
}
