
package cn.smarthse.radiationTraining.modules.sys.service.sys;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysSetting;
import cn.smarthse.radiationTraining.modules.sys.param.sys.ParamQueryParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SaveSysSettingParam;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysSettingVo;
import com.baomidou.mybatisplus.extension.service.IService;
import java.util.List;

/**
 *
 * 系统设置 service
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/24 15:42
 */
public interface ISysSettingService extends IService<SysSetting> {

    /**
     * 系统设置-列表(分页)
     * @param param -
     * @return {@link LayuiGridData<SysSettingVo>}
     * @author liaoly
     * @date 2022/3/24 16:08
     */
    LayuiGridData<SysSettingVo> getSettingListData(ParamQueryParam param);

    /**
     * 系统设置-保存
     * @param param -
     * @author liaoly
     * @date 2022/3/24 17:29
     */
    void saveSetting(SaveSysSettingParam param);

    /**
     * www：系统设置-列表
     * @return {@link LayuiGridData<SysSettingVo>}
     * @author liaoly
     * @date 2022/3/24 16:08
     */
    List<SysSettingVo> getApiSettingList();

    /**
     * @description 获取详情
     * @param code
     * @return java.lang.Object
     * @author chenliang
     * @date 2022/8/31 18:15:38
     */
    SysSettingVo getSetting(String code);

    /**
     * @description 获取详情(根据类型获取)
     * @param type 类型
     * @return java.lang.Object
     * @author chenliang
     * @date 2022/8/31 18:15:38
     */
    List<SysSettingVo> getSettingByType(String type);

    /**
     * @description: 直接从数据获取，越过缓存
     * @author: chenliang
     * @date: 2023/8/17 9:24
     * @param code
     * @return: {@link SysSettingVo}
     */
    SysSettingVo getSettingFromDB(String code);

    /**
     * @description: 获取安卓app连接
     * @author: chenliang
     * @date: 2023/8/21 15:31
     * @return: {@link Object}
     */
    String getAndroidAppUrl();

    /**
     * @description: 获取苹果app连接
     * @author: chenliang
     * @date: 2023/8/21 15:31
     * @return: {@link Object}
     */
    String getAppleAppUrl();
}
