package cn.smarthse.radiationTraining.modules.sys.service.sys;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.dto.sys.MsgDto;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysMsg;
import cn.smarthse.radiationTraining.modules.sys.param.sys.MsgQueryParam;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.MsgStatisticsVo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.MsgVo;
import com.baomidou.mybatisplus.extension.service.IService;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 个人、企业消息service
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @since 2022-02-12
 */
public interface IMsgService extends IService<SysMsg> {

    /**
     * 推送消息(单一用户)
     *
     * @author liaoly
     * @date 2021年3月29日 下午5:16:24
     * @param msgDto : 消息参数
     */
    void pushMsg(MsgDto msgDto);

    /**
     * 查询用户的消息列表-分页
     * @param param -
     * @return {@link LayuiGridData<MsgVo>}
     * @author liaoly
     * @date 2022/3/21 15:02
     */
    LayuiGridData<MsgVo> getMsgList(MsgQueryParam param);

    /**
     * 方法描述:  查询未读条数
     *
     * @param   param 查询参数
     * @return  Integer
     * @author  wuxq
     * @date    2022/4/14
     */
    Integer getUnreadMsgNum(Long userId);

    /**
     * 保存已读状态
     * @param msgIdList 消息id集合(为空则全部已读)
     * @param userId 账号id (非空)
     * @author liaoly
     * @date 2022/3/21 15:23
     */
    void readMsg(List<Long> msgIdList, @NotNull Long userId);

    /**
     * 删除
     * @param msgIdList 消息id集合(为空则全部删除)
     * @param userId 账号id (非空)
     * @author liaoly
     * @date 2022/3/21 15:22
     */
    void del(List<Long> msgIdList, @NotNull Long userId);

    /**
     * 查询用户未读消息数量
     * @param userId 账号id (非空)
     * @return {@link int}
     * @author liaoly
     * @date 2022/4/14 17:11
     */
    long getUnReadNum(Long loginUserId);

    /***
     * @description 统计消息
     * @param loginUserId
     * @return cn.smarthse.radiationTraining.modules.sys.vo.sys.MsgStatisticsVo
     * @author chenliang
     * @date 2022/6/27 16:22:30
     */
    MsgStatisticsVo getMsgCount(Long loginUserId);
}
