package cn.smarthse.radiationTraining.modules.sys.service.order.payNotify;

import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrder;
import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderTypeEnum;

/**
 *
 * 支付回调执行器标准接口
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/4/22 14:57
 */
public interface IPayNotifyExecute {

    /**
     * 订单类型
     * @return {@link OrderTypeEnum}
     * @author liaoly
     * @date 2022/4/20 15:02
     */
    OrderTypeEnum getOrderType();

    /**
     * 支付回调执行
     * @param order {@link SysOrder}
     * @return {@link Boolean} 是否恢复成功 true 成功 false 失败
     * @author liaoly
     * @date 2022/4/20 15:02
     */
    boolean invoke(SysOrder order);
}
