
package cn.smarthse.radiationTraining.modules.sys.service.order;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrder;
import cn.smarthse.radiationTraining.modules.sys.param.order.AddOrderParam;
import cn.smarthse.radiationTraining.modules.sys.param.order.QueryOrderParam;
import cn.smarthse.radiationTraining.modules.sys.param.order.UserQueryOrderParam;
import cn.smarthse.radiationTraining.modules.sys.vo.order.SysOrderDetailModel;
import cn.smarthse.radiationTraining.modules.sys.vo.order.SysOrderModel;
import cn.smarthse.radiationTraining.modules.sys.vo.order.SysOrderRefundAuditVo;
import cn.smarthse.radiationTraining.modules.sys.vo.order.UserOrderVo;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * 订单service
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午1:35:51
 */
public interface ISysOrderService extends IService<SysOrder> {

    /**
     * 监管端：查询订单列表(分页)
     *
     * @param param
     * @return PageInfo<SysOrderModel>
     * @author liaoly
     * @date 2021年8月2日 下午1:41:27
     */
    LayuiGridData<SysOrderModel> getOrderListData(QueryOrderParam param);

    /**
     * 用户端：查询订单列表(分页)
     *
     * @param param
     * @return PageInfo<UserOrderModel>
     * @author liaoly
     * @date 2021年8月2日 下午1:41:27
     */
    LayuiGridData<SysOrderDetailModel> getUserOrderListData(UserQueryOrderParam param);

    /**
     * 删除订单
     *
     * @param idList
     * @param adminId 操作账号id
     *                void
     * @author liaoly
     * @date 2021年8月2日 下午2:17:12
     */
    void delOrder(List<Long> idList, Long adminId);

    /**
     * 查询订单状态
     *
     * @param orderId : 订单id
     * @return SysOrder
     * @author liaoly
     * @date 2021年8月3日 下午5:37:22
     */
    SysOrder getOrderState(Long orderId);

    /**
     * 用户下单-商品
     *
     * @param param
     * @return SysOrderModel
     * @author liaoly
     * @date 2021年8月2日 下午1:49:23
     */
    SysOrderModel addOrderByUser(AddOrderParam param);

    /**
     * 用户-订单申请退款
     *
     * @param orderId       订单id
     * @param refundReason  退款原因
     * @param currentUserId 当前用户id
     * @author liaoly
     * @date 2022/4/19 17:30
     */
    void applyRefund(Long orderId, Long currentUserId, String currentUserName);

    /**
     * 根据订单id集合，删除订单信息
     *
     * @param orderId 订单id
     * @param userId  用户id
     * @author liaoly
     * @date 2022/4/25 8:25
     */
    void delOrderByUser(Long orderId, Long userId);

    /**
     * 用户：查询订单详情
     *
     * @param userId  账号id
     * @param orderId 订单id
     * @return {@link UserOrderVo}
     * @author liaoly
     * @date 2022/4/27 17:18
     */
    UserOrderVo getUserOrder(Long userId, Long orderId);

    /**
     * 用户：获取某某商品最新订单
     *
     * @param userId  账号id 需要身份校验时，传入userId
     * @param goodsId 商品id
     * @return {@link UserOrderVo}
     * @author chenliang
     * @date 2022/5/7 17:12
     */
    UserOrderVo getNewestUserOrderByGoodsId(Long userId, Long goodsId);

    /**
     * 方法描述:  订单详情
     *
     * @param id 订单id
     * @return UserOrderModel
     * @author wuxq
     * @date 2023/5/30
     */
    SysOrderDetailModel getOrderDetails(Long id);

    /**
     * @description: 根据buinessId 获取 订单
     * @author: chenliang
     * @date: 2023/6/13 14:24
     * @param: businessId
     * @return: cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrder
     */
    SysOrder getByBuinessId(Long businessId);

    /**
     * 方法描述:  订单退款审核详情
     *
     * @param id 订单id
     * @return SysOrderRefundAuditVo
     * @author wuxq
     * @date 2023/12/18
     */
    SysOrderRefundAuditVo getSysOrderRefundAuditVo(Long id);

    /**
     * 方法描述:  根据businessId查询（企业报名或证书生成） 是否完成支付，true-完成，false-未支付
     *
     * @param businessId 业务数据id
     * @return boolean
     * @author wuxq
     * @date 2023/12/28
     */
    boolean checkPayedByBusinessId(Long businessId);

}
