package cn.smarthse.radiationTraining.modules.sys.service.order;

import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrderLog;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * 订单记录service
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午1:35:51
 */
public interface ISysOrderLogService extends IService<SysOrderLog> {

    /**
     * 方法描述:  添加订单操作记录
     *
     * @param   log 订单操作记录
     * @return  void
     * @author  wuxq
     * @since    2025/5/21
     */
    void addOrderLog(SysOrderLog log);

    /**
     * 方法描述:  查询订单操作记录
     *
     * @param   orderId 订单id
     * @return  List<SysOrderLog>
     * @author  wuxq
     * @since    2025/5/21
     */
    List<SysOrderLog> getOrderLogList(Long orderId, Long userId);

}
