package cn.smarthse.radiationTraining.modules.sys.provider.user.info;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.dto.user.info.ImportCompanyData;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysCompany;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysCompanyRisk;
import cn.smarthse.radiationTraining.modules.sys.param.sys.AddSysCompanyRiskParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SearchCompanyPageParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.UpdateHeadImgParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.info.QueryCompanyParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.info.SaveCompanyParam;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.*;

import java.util.List;

/**
 * 单位底库dubbo服务
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/17 11:00
 */
public interface ICompanyProviderService {

    /**
     * 单位底库-分页列表
     *
     * @param param 参数
     * @return {@link LayuiGridData<CompanyListVo>}
     * @author liaoly
     * @date 2022/3/17 11:06
     */
    LayuiGridData<CompanyListVo> getCompanyList(QueryCompanyParam param);

    /**
     * 医院单位底库-列表
     * @author chuhy
     * @date 2024/11/6 10:04
     */
    LayuiGridData<RhoCompanyListVo> getCompanyListForRho(QueryCompanyParam param);

    /**
     * 单位底库-详情
     *
     * @param id 单位底库id
     * @return {@link CompanyVo}
     * @author liaoly
     * @date 2022/3/17 11:24
     */
    CompanyVo getCompany(Long id);

    /**
     * 单位底库-获取单位用户id
     *
     * @param id 单位底库id
     */
    Long getUidById(Long id);

    /**
     * 单位底库-编辑
     *
     * @param param -
     * @author liaoly
     * @date 2022/3/17 13:17
     */
    void saveUser(SaveCompanyParam param);

    /**
     * 方法描述:  保存
     *
     * @param   company 参数
     * @return  SysCompany
     * @author  wuxq
     * @date    2022/3/29
     */
    SysCompany save(SysCompany company);

    /**
     * 单位底库-导入
     * @param list easyexcel解析出来的数据
     * @author liaoly
     * @date 2022/3/17 14:33
     */
    void importCompany(List<ImportCompanyData> list);

    /**
     * 单位底库-导出
     * @param param -
     * @return {@link List<CompanyExportListVo>}
     * @author liaoly
     * @date 2022/3/17 17:50
     */
    List<CompanyExportListVo> getExportCompanyList(QueryCompanyParam param);

    /**
     * 根据关键词搜索，不分页
     * @param keyword
     * @return
     */
    List<SearchCompanyVo> searchCompanyByKeywordForSelect(String keyword,Integer ifIncludeSelected);

    /**
     * 根据关键词、区域搜索，不分页
     * @param param
     * @return
     */
    LayuiGridData<SearchCompanyVo> searchCompanyPageByKeywordAndArea(SearchCompanyPageParam param);

    /**
     * @description 同步危害因数关联
     * @param paramList
     * @return void
     * @author chenliang
     * @date 2022/8/19 15:47:04
     */
    void synRiskFactor(List<AddSysCompanyRiskParam> paramList);
    /**
     * @description 获取危害因素
     * @param cid
     * @return
     * @author chenliang
     * @date 2022/8/19 16:25:34
     */
    List<SysCompanyRisk> getRiskFactor(Long cid);
}
