package cn.smarthse.radiationTraining.modules.sys.provider.user;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.dto.user.UserToAdminDto;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.param.ForbiddenParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.*;
import cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.CidTokenMapVo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.CompanyModifyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserCropListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserCropVo;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 单位账号-dubbo服务
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2022/2/16 20:51
 */
public interface IUserCropProviderService {

    /**
     * 查询用户中心-账号信息
     *
     * @param userId : 账号id
     * @return cn.doubi.learn.modules.user.dto.user.UserToAdminTdo
     * @author liaoly
     * @date 2022/2/16 20:55
     */
    UserToAdminDto getUserDto(Long userId);

    /**
     * 根据手机号查询用户
     *
     * @param phone phone
     * @return User
     */
    SysUser selectUserByPhone(String phone);

    /**
     * 查询用户信息
     *
     * @param token 匹配账号、手机号、邮箱
     * @return User
     */
    SysUser getUserByToken(String token);

    /**
     * 用户注册,默认密码为手机号后六位
     *
     * @param phone phone
     * @param args  密码
     * @return userId
     */
    Long register(String phone, String... args);

    /**
     * 修改密码-by 手机号
     *
     * @param phone       手机号
     * @param newPassword 密码
     */
    void modifyPasswordByPhone(String phone, String newPassword);

    /**
     * 修改密码-by 邮箱
     *
     * @param email       邮箱
     * @param newPassword 密码
     */
    void modifyPasswordByEmail(String email, String newPassword);
    void modifyEmailByLoginUserId(String email, Long userId);

    /**
     * 输入旧密码修改密码验证码
     *
     * @param phone       手机号
     * @param oldPassword 旧密码
     * @param newPassword 新密码
     */
    void modifyPasswordByOldPwd(String phone, String oldPassword, String newPassword);

    /**
     * 更新操作
     *
     * @param user :
     * @return boolean
     * @author liaoly
     * @date 2022/2/17 22:12
     */
    boolean updateById(SysUser user);

    /**
     * 企业账号-列表
     *
     * @param param param
     * @return {@link LayuiGridData<UserCropListVo>}
     * @author liaoly
     * @date 2022/3/11 16:03
     */
    LayuiGridData<UserCropListVo> getUserList(QueryUserParam param);

    /**
     * 查询用户中心-账号信息
     *
     * @param userId 账号id
     * @return {@link UserCropVo}
     * @author liaoly
     * @date 2022/3/7 13:13
     */
    UserCropVo getUserVo(Long userId);
    UserCropVo getFullUserInfo(Long userId);

    /**
     * 单位账号-编辑
     *
     * @param param 参数
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2022/3/11 15:12
     */
    void saveUser(SaveUserCropParam param);

    /**
     * 单位账号-删除
     *
     * @param idList  账号id集合
     * @param adminId 操作账号id
     * @author liaoly
     * @date 2022/3/11 15:16
     */
    void del(List<Long> idList, Long adminId);

    /**
     * 单位账号-禁用、启用
     *
     * @param param 参数
     * @author liaoly
     * @date 2022/3/11 15:28
     */
    void forbiddenUser(ForbiddenParam param);

    /**
     * 单位账号-重置密码
     *
     * @param idList  账号id集合
     * @param adminId 操作账号id
     * @author liaoly
     * @date 2022/3/11 15:18
     */
    void resetPassword(List<Long> idList, Long adminId);


    /**
     * 单位用户：修改或者添加企业信息底库
     * @param saveUserCropParam
     */
    void saveUserAndCompany(EditCropParam param);

    /**
     * 单位导入员工
     * @param corpStafferRegisterParam
     * @return
     */
    SysUser corpImportSingleUser(CorpStafferRegisterParam corpStafferRegisterParam);
    /**
     * 单位批量导入员工
     * @param registerUserParamList
     * @return
     */
    List<SysUser> corpImportSingleUserList(List<CorpStafferRegisterParam> registerUserParamList);

    /**
     * 更新头像
     * @param param
     */
    void updateHeadImg(UpdateHeadImgParam param);

    /**
     * 方法描述:  单位用户注册
     *
     * @param   companyUserParam 参数对象
     * @return  void
     * @author  wuxq
     * @date    2022/3/15
     */
    void companyUserRegister(RegisterCompanyUserParam companyUserParam);

    /**
     * 单位用户注册 by 单点登录，默认密码为“123456”(存在就更新部分数据，不存在就创建)
     * @return {@link SysUser}
     * @author liaoly
     * @date 2022/8/9 9:48
     */
    SysUser registerByUsername(RegisterCompanyUserParam param);

    /**
     * 对已报名的单位但还没有账号的单位生成账号
     * @author chuhy
     * @date 2023/5/12 8:45
     */
    void genUnitAccount();

    /**
     * @description 根据企业id获取账号
     * @param cid
     * @return
     * @author chenliang
     * @date 2022/8/26 15:01:05
     */
    SysUser getByCid(Long cid);
    List<CidTokenMapVo> getListByToken(List<Long> tokenList);

    CompanyInfo getCompanyByUserId(Long userId);

    /**
     * 查询培训系统中所有企业token
     * @return Map
     * @author chuhy
     * @date 2022/10/09
     */
    Set<String> getAllCompanyToken();

    /**
     * 同步接口，修改单位相关信息
     *
     * @author chuhy
     * @date 2022/10/09
     */
    Object modifyCompanyFromHSE(List<CompanyModifyVo> list);

    /**
     * @description 根据公司id列表，获取账号列表
     * @param cidList
     * @return java.util.List<cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser>
     * @author chenliang
     * @date 2022/10/10 15:11:54
     */
    List<SysUser> getByCidList(List<Long> cidList);
}
