package cn.smarthse.radiationTraining.modules.sys.provider.sys;

import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysParam;

import cn.smarthse.radiationTraining.modules.sys.param.ForbiddenParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.ParamQueryParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SaveSysParam;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysParamVo;
import java.util.List;

/**
 *
 * 系统模块-数据字典dubbo服务
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/30 8:19
 */
public interface ISysParamProviderService {
    /**
     * 数据字典-列表
     * @param param -
     * @return {@link List<SysParamVo>}
     * @author liaoly
     * @date 2022/3/22 11:07
     */
    List<SysParamVo> getParamList(ParamQueryParam param);

    /**
     * 数据字典-列表分页
     * @param param -
     * @return {@link LayuiGridData <SysParamVo>}
     * @author liaoly
     * @date 2022/3/22 11:07
     */
    LayuiGridData<SysParamVo> getParamListData(ParamQueryParam param);

    /**
     * 数据字典-编辑
     * @param param
     * @author liaoly
     * @date 2022/3/22 11:40
     */
    void saveParam(SaveSysParam param);

    /**
     * 数据字典-删除
     * @param param -
     * @author liaoly
     * @date 2022/3/22 14:31
     */
    void delParam(IdsParam param);

    /**
     * 数据字典-停用、启用
     * @param param -
     * @author liaoly
     * @date 2022/3/22 14:16
     */
    void forbiddenParam(ForbiddenParam param);

    /**
     * 通过type 和 code 查找
     * @param type
     * @param workTypeCode
     * @return
     */
    SysParam getByTypeAndCode(String type, String workTypeCode);

    /**
     * 通过type和codes获取名字集合
     * @param type
     * @param codes
     * @return
     */
    List<String> getNamesByTypeAndCodes(String type,List<String> codes);

    /**
     * 方法描述:  根据名称返回codes
     *
     * @param   names 系统参数名称集合
     * @return  String 以 , 分隔
     * @author  wuxq
     * @date    2022/4/1
     */
    String getCodesByNames(List<String> names);

    /**
     * 通过type和keyword获取
     * @param type
     * @param keyword
     * @return
     */
    List<SysParam> getByTypeAndKeyword(String type,String keyword);

    /**
     * 通过codes获取名字
     * @param codes
     * @return
     */
    List<String> getNamesByCodes(List<String> codes);

    /**
     * 通过code获取SysParam
     * @param workTypeCode
     * @return
     */
    SysParam getByCode(String workTypeCode);

    /**
     * 方法描述:  根据pcode查职业照射代码
     *
     * @param   pcode
     * @return  String
     * @author  wuxq
     * @date    2022/5/19
     */
    String getOccExpCodeByPcode(String pcode);
}
