package cn.smarthse.radiationTraining.modules.sys.provider.sys;

import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFileModel;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFileVo;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 *
 *  系统附件服务service
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/9 15:39
 */
public interface ISysFileProvideService {

	/**
	 * 根据文件id查询文件详情
	 * @param fileId : 文件id
	 * @return SysFileModel
	 */
	SysFileModel getFileById(Long fileId);

	/**
	 * 根据文件hash值获取文件
	 * @param filehash : 文件hash值
	 * @return SysFileModel
	 */
	SysFileModel getFileByHash(String filehash);

	/**
	 * 根据文件Id获得文件全路径地址
	 * @param fileId : 文件id
	 * @return String
	 */
	String getFileUrl(Long fileId);

	/**
	 * @description: 根据文件Id获得文件全路径地址对象
	 * @author: chenliang
	 * @date: 2023/10/19 11:12
	 * @param fileId
	 * @return: {@link SysFileModel}
	 */
	SysFileModel getFileUrlModel(Long fileId);

	/**
     * 根据主键字符串进行查询，类中只有存在一个带有@Id注解的字段
     *
     * @param ids 如 "1,2,3,4"
     * @return List<SysFileModel>
     */
	List<SysFileModel> getListByIds(String ids);

	/**
	 * 根据主键字符串进行查询，类中只有存在一个带有@Id注解的字段
	 *
	 * @param idList 文件id集合
	 * @return List<SysFileModel>
	 */
    List<SysFileModel> getListByIds(List<Long> idList);

	/**
	 * 通用的文件上传接口
	 * @param record : 文件对象
	 * @param adminId : 操作账号id，可为空
	 * @return
	 */
	SysFileModel addSysFile(SysFileModel record, Long adminId);

	/**
	 * 文件上传接口（同一个hash只能上传一次）
	 * @Author ChenLiang
	 * @Date 10:43 2024/7/19
	 * @param record
	 * @param adminId
	 * @return SysFileModel
	 */
	SysFileModel addOnlySysFile(SysFileModel record, Long adminId);

	SysFileModel getFileByUrl(String url);

	/**
	 * 根据ids 查询文件信息
	 * @param ids id有逗号隔开
	 * @return {@link List<SysFileVo>}
	 * @author liaoly
	 * @date 2022/3/18 9:34
	 */
	List<SysFileVo> getFileVoByIds(String ids);

}
