package cn.smarthse.radiationTraining.modules.sys.provider.admin;

import cn.smarthse.radiationTraining.modules.sys.entity.admin.Admin;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;

/**
 * 提供给admin的 后台账号 admin 服务
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/4 14:45
 */
public interface IAdminProviderService {

    /**
     * 根据id查询用户
     *
     * @param userId userId
     * @return Admin
     */
    Admin selectUserById(Long userId);

    /**
     * 用户注册,默认密码为"123456"
     * @param username 账号
     * @param name 昵称
     * @param areaId 行政区划12位编码
     * @param token token令牌
     * @return Admin
     */
    Admin registerByUsername(String username, String name, Long areaId, String token);

    /**
     * 更新操作
     *
     * @param user :
     * @return boolean
     * @author liaoly
     * @date 2022/2/17 22:12
     */
    boolean updateById(Admin user);

    /**
     * 根据令牌Token查询账号信息
     * @param token 令牌Token 职业健康在线监管账号的id
     * @return {@link SysUser}
     * @author liaoly
     * @date 2022/8/9 9:48
     */
    Admin getByThirdToken(String token);
}
