package cn.smarthse.radiationTraining.modules.sys.param.user.uc;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 个人用户-编辑参数
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/10 17:14
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class EditUserParam extends UserEditParam {

    private static final long serialVersionUID = 3055226672737277076L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty(value = "姓名", required = true)
    private String name;

    @ApiModelProperty(value = "邮箱", required = true)
    private String email;

    @ApiModelProperty(value = "证件号", required = true)
    private String idcard;

    @ApiModelProperty(value = "证件号类型（0中国居民身份证、1外国人永久居留身份证、2港澳台居民居住证、3港澳居民来往内地通行证、4台湾居民来往大陆通行证、5护照）", required = true)
    private Integer idcardType;

    @ApiModelProperty(value = "老身份证号", required = true)
    private String oldIdcard;

    @ApiModelProperty(value = "性别（1-男；0-女）")
    private Integer sex;

    @ApiModelProperty(value = "头像url")
    private String avatar;

    @ApiModelProperty(value = "证件照url")
    private String photoUrl;

    @ApiModelProperty(value = "学历code")
    private String education;

    @ApiModelProperty(value = "覆盖类型(1都不覆盖 2覆盖姓名3覆盖姓名和身份证)")
    private Byte coverType;

    @ApiModelProperty(value = "工作类别code（单选）", hidden = true)
    private String workType;

    @ApiModelProperty(value = "放射工作开始时间", hidden = true)
    private Date radiationWorkDate;

    @ApiModelProperty(value = "单位id", hidden = true)
    private Long companyId;

    @ApiModelProperty(value = "单位名称", hidden = true)
    private String companyNname;

    @ApiModelProperty(value = "社会信用代码", hidden = true)
    private String creditCode;

    @ApiModelProperty(value = "行政区划", hidden = true)
    private Long areaId;

    @ApiModelProperty(value = "详细注册地址", hidden = true)
    private String addressDetail;

}
