package cn.smarthse.radiationTraining.modules.sys.param.user;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 个人账号-培训次数查询
 *
 * @author chuhy
 * @date 2022/10/13
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class UserTrainTimesParam extends PageParam {

    private static final long serialVersionUID = -7026812865882137840L;

    @ApiModelProperty(value = "用户ID")
    private Long uid;

    @ApiModelProperty(value = "是否为指定账号",hidden = true)
    private Boolean isSpecifiedUser = false;

    public UserTrainTimesParam() {
    }

    public UserTrainTimesParam(Boolean isSpecifiedUser) {
        this.isSpecifiedUser = isSpecifiedUser;
    }


}
