package cn.smarthse.radiationTraining.modules.sys.param.user;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 个人账号、单位账号-查询
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/10 17:14
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class QueryUserParam extends PageParam {

    private static final long serialVersionUID = 8612455483419584250L;

    @ApiModelProperty("是否禁用（1-禁用；0-启用）")
    private Integer isForbidden;

    @ApiModelProperty(value = "用户区域")
    private Long tid;

    @ApiModelProperty(value = "是否为测试账号(0否 1是)")
    private Integer isTest;

    @ApiModelProperty(value = "用户ID",hidden = true)
    private Long uid;

    @ApiModelProperty(value = "用户区域",hidden = true)
    private Long userArea;

    @ApiModelProperty(value = "用户区域level",hidden = true)
    private int areaLevel;

    @ApiModelProperty(value = "是否已经注册协会会员",hidden = true)
    private Integer hasRegisteredXh;

    @ApiModelProperty(value = "是否是放射工作人员",hidden = true)
    private Integer isRayWork;

    @ApiModelProperty(value = "是否为指定账号",hidden = true)
    private Boolean isSpecifiedUser = false;
}
