package cn.smarthse.radiationTraining.modules.sys.param.user;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.Email;
import java.io.Serializable;

/**
 * 企业给员工注册账号
 *
 * @author
 * @date
 */
@Data
@Accessors(chain = true)
public class CorpStafferRegisterParam implements Serializable {

    private static final long serialVersionUID = 3055226672737277076L;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("邮箱")
    @Email
    private String email;

    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("身份证号")
    private String idCard;

    @ApiModelProperty("验证码")
    private String vcode;
    @ApiModelProperty("公司id")
    private Long cid;
    @ApiModelProperty("操作人id")
    private Long loginUserId;

}
