package cn.smarthse.radiationTraining.modules.sys.param.sys;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @ClassName SearchCompanyParam
 * @Description
 * @Author ChenLiang
 * @ModifyDate 2022/3/22 14:43
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class SearchCompanyPageParam extends LayuiGridParam {
    @ApiModelProperty("关键字")
    private String keyword;

    @ApiModelProperty(value = "行政区划id")
    private Long areaId;

    @ApiModelProperty(value = "行政区划level", hidden = true)
    private Integer level;
    @ApiModelProperty(value = "是否包含被选择的单位（0不包含1包含）")
    private Integer ifIncludeSelected;

    public Integer getLevel() {
        return StringUtils.getAreaLevel(this.areaId);
    }
}
