package cn.smarthse.radiationTraining.modules.sys.param.sys;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 *
 * 编辑数据字典参数
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/22 11:31
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SaveSysParam extends UserEditParam {

    private static final long serialVersionUID = -7668105133874690483L;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "数据字典名", required = true)
    private String name;

    @ApiModelProperty(value = "父code（默认为0）", required = true)
    private Long pid;

    @ApiModelProperty(value = "备注")
    private String desc;


    @ApiModelProperty("系统默认参数（0-否；1-是）")
    private Integer isDefault;
}
