package cn.smarthse.radiationTraining.modules.sys.param.sys;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName SaveFeedbackParam
 * @Description 存储反馈的参数
 * @Author ChenLiang
 * @ModifyDate 2022/3/23 9:11
 */

@Data
@Accessors
public class SaveFeedbackParam extends UserEditParam implements Serializable {

    /**
     * 反馈类型，枚举FeedbackEnum
     */
    @ApiModelProperty(value = "反馈类型FeedbackEnum(企业错误信息反馈（企业名）100001,企业错误信息反馈（社会信用代码）100002,企业错误信息反馈（注册地址）100003)")
    private String type;
    /**
     * 反馈内容
     */
    @ApiModelProperty(value = "反馈内容")
    private String content;
    /**
     * 联系方式，可以手机、电话、邮件等等
     */
    @ApiModelProperty(value = "联系方式，可以手机、电话、邮件等等")
    private String contactWay;

    @ApiModelProperty(value = "公司id")
    private Long cid;

}
