package cn.smarthse.radiationTraining.modules.sys.param.order;

import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderPayTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderSourceTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 添加订单-表单()
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午1:50:23
 */
@Data
public class UserAddOrderTrainingParam implements Serializable {

    private static final long serialVersionUID = 71562368475698116L;

    @ApiModelProperty("商品id")
    private Long goodsId;

    @ApiModelProperty("订单标题")
    private String subject;

    @ApiModelProperty("商品总金额")
    private BigDecimal goodsPrice;

    @ApiModelProperty("订单类型 OrderTypeEnum")
    private Integer orderType;

    @ApiModelProperty("付费类型(1-线上支付; 2-线下支付；3-赠送)")
    private Integer payType = OrderPayTypeEnum.ONLINE.getValue();

    @ApiModelProperty(value = "创建类型(1-用户创建，2-后台创建)", hidden = true)
    private Integer sourceType = OrderSourceTypeEnum.BY_USER.getValue();

    @ApiModelProperty(value = "订单最晚签收时间（用于某些跨越长时间段的订单标志完成时间），之后可以开票等")
    private Date receiptEndDate;

    @ApiModelProperty(value = "关联账号id", hidden = true)
    private Long userId;

    @ApiModelProperty(value = "关联账号", hidden = true)
    private String username;

    @ApiModelProperty(value = "用户类型(2-个人端，3-企业端)", hidden = true)
    private Integer userType;

    public UserAddOrderTrainingParam() {
    }

    public UserAddOrderTrainingParam(Long goodsId, BigDecimal goodsPrice, Integer payType, Integer sourceType, Date receiptEndDate, Long userId, String username, Integer userType) {
        this.goodsId = goodsId;
        this.goodsPrice = goodsPrice;
        this.payType = payType;
        this.sourceType = sourceType;
        this.receiptEndDate = receiptEndDate;
        this.userId = userId;
        this.username = username;
        this.userType = userType;
    }
}
