package cn.smarthse.radiationTraining.modules.sys.param.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 添加订单-表单()
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午1:50:23
 */
@Data
public class AddOrderParam implements Serializable {

    private static final long serialVersionUID = 71562368475698116L;

    /**
     * 商品id
     */
    private Long goodsId;

    /**
     * 业务id（个人-tu_enroll_detail.id; 单位-tu_enroll_batch.id）
     */
    private Long businessId;

    /**
     * 商品名称
     */
    private String subject;

    /**
     * 商品单价
     */
    private BigDecimal unitPrice;

    /**
     * 关联账号id
     */
    private Long userId;
    /**
     * 关联账号
     */
    private String username;
    /**
     * 用户姓名
     */
    private String nickname;

    /**
     * 订单类型(OrderTypeEnum 1-培训费)
     */
    private Integer orderType = 1;

    //==================================================================================================================

    /**
     * 商品数量
     */
    private Integer quantity = 1;

    /**
     * 商品总额
     */
    private BigDecimal goodsPrice;

    /**
     * 交易金额
     */
    private BigDecimal payMoney;

    /**
     * 三方支付方式 OrderThirdPayTypeEnum(微信支付-1; 支付宝支付-2)
     */
    private Integer thirdPayType = 2;

    /**
     * 付费类型(1-线上支付; 2-线下支付；3-赠送)
     */
    private Integer payType = 1;

    public AddOrderParam() {
    }

    public AddOrderParam(Long goodsId,Long businessId, Long userId, String username, Integer payType, Integer orderType,
                         BigDecimal payMoney, Integer thirdPayType) {
        this.goodsId = goodsId;
        this.businessId = businessId;
        this.payType = payType;
        this.payMoney = payMoney;
        this.orderType = orderType;
        this.userId = userId;
        this.username = username;
        this.thirdPayType = thirdPayType;
    }
}
