package cn.smarthse.radiationTraining.modules.sys.param;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 通用的数据 禁用、启用参数
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/10 17:14
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class ForbiddenParam extends UserEditParam {

    private static final long serialVersionUID = 3055226672737277076L;

    @ApiModelProperty(value = "id集合", required = true)
    private List<Long> idList;

    @ApiModelProperty(value = "是否禁用/停用（1-禁用/停用；0-启用）", required = true)
    private Integer isForbidden;
}
