package cn.smarthse.radiationTraining.modules.sys.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <h1>企业、个人用户消息类型 枚举</h1>
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年3月29日 下午3:52:08
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum MsgTypeEnum {

    /**
     * 系统消息: sys
     */
    sys("系统消息", "sys", "系统消息"),

    /**
     * 培训信息: training_enroll
     */
    training_enroll("培训信息", "training_enroll", "您的报名“%s”培训被用人单位/培训机构退回，可重新编辑信息进行报名>>", "url"),
    training_enroll_crop("培训信息", "training_enroll_crop", "单位给您的报名“%s”培训，可去个人中心学习>>", "url"),
    training_enroll_crop2("培训信息", "training_enroll_crop2", "您的报名“%s”培训被管理员退回，可重新编辑信息进行报名>>", "url"),
    training_enroll_sendback_crop("培训信息","training_enroll_sendback_crop","您报名的培训“%s培训”，被%s单位退回，可前往在线培训模块重新报名"),
    /**
     * 培训信息: training_enroll
     */
    training_choose("培训信息", "training_choose", "现有“%s”学员报名“%s”培训中将贵单位选为其所在用人单位，您可前往我的培训-培训详情-报名人员列表中核查该人员是否为贵单位人员，如有误可退回该人员报名!", "url"),

    training_remind("培训信息", "training_remind", "您的培训“%s”剩余培训时间不足3天，您尚未完成所有课程学习，请前往“我的培训”尽快完成学习！", "url"),
    training_test_remind("培训信息", "training_test_remind", "您的培训“%s”距离考试截止时间不足3天，您尚有必过课程未考试或未通过，请前往“我的考试”尽快通过所有必过考试！", "url")
    ;

    private String name;

    private String value;

    private String content;

    private String url;

    MsgTypeEnum(String name, String value, String content, String url) {
        this.name = name;
        this.value = value;
        this.content = content;
        this.url = url;
    }

    MsgTypeEnum(String name, String value, String content) {
        this.name = name;
        this.value = value;
        this.content = content;
    }

    public static MsgTypeEnum getMsgTypeEnum(String value) {
        if (value == null) {
            return MsgTypeEnum.sys;
        }
        for (MsgTypeEnum c : values()) {
            if (c.getValue().equals(value)) {
                return c;
            }
        }
        return MsgTypeEnum.sys;
    }

    public static String getContent(String value) {
        if (value == null) {
            return null;
        }
        for (MsgTypeEnum c : values()) {
            if (c.getValue().equals(value)) {
                return c.content;
            }
        }
        return null;
    }

    public static String getUrl(String value) {
        if (value == null) {
            return null;
        }
        for (MsgTypeEnum c : values()) {
            if (c.getValue().equals(value)) {
                return c.url;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }
    public void setValue(String value) {
        this.value = value;
    }

    public String getContent() {
        return content;
    }
    public void setContent(String content) {
        this.content = content;
    }

    public String getUrl() {
        return url;
    }
    public void setUrl(String url) {
        this.url = url;
    }
}