package cn.smarthse.radiationTraining.modules.sys.enums.order;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 三方支付方式(微信支付-1; 支付宝支付-2)
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午2:06:44
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum OrderThirdPayTypeEnum {
	/**
	 * 微信支付-1
	 */
	WX_PAY("微信支付", 1),
	/**
	 * alipay-2
	 */
	ALIPAY("支付宝支付", 2),
	;
	
	private String name;
	
	private Integer value;

	private OrderThirdPayTypeEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (OrderThirdPayTypeEnum c : values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
			
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public Integer getValue() {
		return value;
	}
	public void setValue(Integer value) {
		this.value = value;
	}
}