package cn.smarthse.radiationTraining.modules.sys.enums.order;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 付费类型(1-线上支付; 2-线下支付；3-赠送)
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午2:06:44
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum OrderPayTypeEnum {
	/**
	 * 线上支付-1
	 */
	ONLINE("线上支付", 1),
	/**
	 * 线下支付-2
	 */
	OFFLINE("线下支付", 2),
	/**
	 * 赠送-3
	 */
	CANCEL_PAY("赠送", 3),
	;
	
	private String name;
	
	private Integer value;

	private OrderPayTypeEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (OrderPayTypeEnum c : values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
			
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public Integer getValue() {
		return value;
	}
	public void setValue(Integer value) {
		this.value = value;
	}
}