package cn.smarthse.radiationTraining.modules.sys.enums.order;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;

/**
 * 订单操作记录类型
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午2:06:44
 */
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum OrderLogTypeEnum {

    /**
     * 成功-1
     */
    PAY_SUCCESS("缴费成功", 1),
    /**
     * 申请退款-2
     */
    REFUND_APPLY("申请退款", 2),
    /**
     * 退款成功-3
     */
    REFUND_SUCCESS("退款成功", 3),
    /**
     * 退款失败-4
     */
    REFUND_FAIL("退款失败", 4),
    ;

    private String name;

    private Integer value;

    OrderLogTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (OrderLogTypeEnum c : values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return null;
    }

    public static OrderLogTypeEnum getOrderType(Integer value) {
        if (value == null) {
            return null;
        }
        for (OrderLogTypeEnum c : values()) {
            if (c.getValue().equals(value)) {
                return c;
            }
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Integer value) {
        this.value = value;
    }
}