package cn.smarthse.radiationTraining.modules.sys.enums.order;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;

/**
 * 
 * 订单开票结果
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午2:06:44
 */
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum OrderInvoiceResultEnum {
	/**
	 * 未开票
	 */
	NO_INVOICE("未开票", 0),
	/**
	 * 已开票
	 */
	YES_INVOICE("已开票", 1),
	;

	private String name;

	private Integer value;

	OrderInvoiceResultEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (OrderInvoiceResultEnum c : values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}

	public static OrderInvoiceResultEnum getOrderType(Integer value) {
		if (value == null) {
			return null;
		}
		for (OrderInvoiceResultEnum c : values()) {
			if (c.getValue().equals(value)) {
				return c;
			}
		}
		return null;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setValue(Integer value) {
		this.value = value;
	}
}