package cn.smarthse.radiationTraining.modules.sys.enums.order;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午2:06:44
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ComboTypeEnum {
	/**
	 * 会员开通
	 */
	VIP_BUY("会员开通", 1),
	/**
	 * 会员开通
	 */
	VIP_RENEW("会员续费", 2),
	/**
	 * 单位会员开通-7
	 */
	UNIT_VIP_BUY("单位会员开通", 7),
	/**
	 * 个人会员开通-8
	 */
	USER_VIP_BUY("个人会员开通", 8),
	/**
	 * 单位会员续费-9
	 */
	UNIT_VIP_RENEW("单位会员续费", 9),
	/**
	 * 个人会员续费-10
	 */
	USER_VIP_RENEW("个人会员续费", 10),
	/**
	 * 商务合作-签约
	 */
	PARTNER_APPLY("商务合作-签约", 3),
	/**
	 * 商务合作-签约
	 */
	PARTNER_RENEW("商务合作-签约", 4),
	/**
	 * 职业健康管理员报名
	 */
	OHP("职业健康管理员报名", 5),
	/**
	 * 在线培训报名-11
	 */
	TRAINING("在线培训报名", 11),
	;
	
	private String name;
	
	private Integer value;

	ComboTypeEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (ComboTypeEnum c : values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
			
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public Integer getValue() {
		return value;
	}
	public void setValue(Integer value) {
		this.value = value;
	}
}