package cn.smarthse.radiationTraining.modules.sys.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 *
 *  性别枚举
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/2/24年17:19月日
 */
@AllArgsConstructor
@Getter
public enum SexEnum {

	/**
	 * 男
	 */
	MAN(1, "MALE", "男"),
	/**
	 * 女
	 */
	WOMAN(0, "FEMALE","女");

	private Integer value;

	private String code;

	private String name;

	public static String getName(Integer index) {
		for (SexEnum c : SexEnum.values()) {
			if (c.getValue().equals(index)) {
				return c.name;
			}
		}
		return null;
	}

	public static Integer getValueByCode(String code) {
		for (SexEnum c : SexEnum.values()) {
			if (c.getCode().equalsIgnoreCase(code)) {
				return c.getValue();
			}
		}
		return null;
	}
}
