
package cn.smarthse.radiationTraining.modules.sys.entity.web;

import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import lombok.Data;

/**
 *
 *  网站-文章
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/10 16:56
 */
@TableName("w_article")
public @Data class Article implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * 
	 */
    @Id
    @Column(name = "ID")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
	private Long id;
	/**
	 * 主题名称
	 */
	private String title;
	/**
	 * 类型：0101-通知公告；0102-信息资讯；0103-政策解读；0104-企业抗疫
	 */
	private String type;
	/**
	 * 类型：01-资讯动态
	 */
	private String itype;
	/**
	 * 简介
	 */
	private String summary;
	/**
	 * 正文内容
	 */
	private String content;
	/**
	 * 封面缩略图url
	 */
	private String imageUrl;
	/**
	 * 附件id
	 */
	private String files;
	/**
	 * 点击量
	 */
	private Integer clicks;
	/**
	 * 状态：0-草稿；1-下架；2-上架；
	 */
	private Integer state;
	/**
	 * 是否置顶（1-置顶；0-不置顶）
	 */
	private Boolean isHome;
	/**
	 * 是否置顶（1-置顶；0-不置顶）
	 */
	private Integer isTop;
	/**
	 * 作者
	 */
	private String author;
	/**
	 * 来源
	 */
	private String resource;

	/**
	 * 发布(上架)时间
	 */
	private Date releaseDate;
	/**
	 * 发布人id
	 */
	private Long releaseBy;
	/**
	 * 发布人
	 */
	private String releaser;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 更新时间
	 */
	private Date updateDate;
	/**
	 * 创建人
	 */
	private Long createBy;
	/**
	 * 更新人
	 */
	private Long updateBy;
	/**
	 * 是否有效
	 */
	private Boolean isValid;


}
