
package cn.smarthse.radiationTraining.modules.sys.entity.user.info;

import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.util.Date;
import javax.persistence.Table;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 
 *  个人用户-基本信息
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/9 10:27
 */
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Table(name = "sys_user_info")
public @Data class SysUserInfo extends BaseBean {

	private static final long serialVersionUID = 5885887098833537020L;

	@TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	/**
	 * 账号id
	 */
	private Long userId;
	/**
	 * 姓名
	 */
	private String name;
	/**
	 * 身份证
	 */
	private String idcard;
	/**
	 * 证件号类型
	 */
	private Integer idcardType;
	/**
	 * 身份证修权力改剩余次数
	 */
	private Integer residueIdcardLimit;
	/**
	 * 性别（1-男；0-女）
	 */
	private Integer sex;
	/**
	 * 生日
	 */
	private Date birthday;
	/**
	 * 所在地
	 */
	private Long areaId;
	/**
	 * 证件照url
	 */
	private String photoUrl;
	/**
	 * 学历
	 */
	private String education;
	/**
	 * 工作类别
	 */
	private String workType;
	/**
	 * 放射工作开始时间
	 */
	private Date radiationWorkDate;

}
