package cn.smarthse.radiationTraining.modules.sys.entity.user.info;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;


/**
 *
 *  企业个人关联信息
 *
 * @author wuxq
 * @date 2022/3/18 10:22
 */
@TableName("sys_company_staff")
@Accessors(chain = true)
public @Data class SysCompanyStaff implements Serializable{

	private static final long serialVersionUID = 1L;
	/**
	 * ID
	 */
	@TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	/**
	 * 企业id（sys_company.id）
	 */
	private Long cid;
	/**
	 * 员工id（sys_user_info.id）
	 */
	private Long staffId;
	/**
	 * 来源(1-培训；2-卫企学习)
	 */
	private Integer source;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 最后修改时间
	 */
	private Date updateDate;
	/**
	 * 创建人
	 */
	private Long createBy;
	/**
	 * 最后修改人ID
	 */
	private Long updateBy;
	/**
	 * 是否有效（0-无效，1-有效）
	 */
	private Boolean isValid;


}
