
package cn.smarthse.radiationTraining.modules.sys.entity.user.info;

import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 *
 *  企业-基础信息
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/9 10:22
 */
@EqualsAndHashCode(callSuper = true)
@TableName("sys_company")
@Accessors(chain = true)
public @Data class SysCompany extends BaseBean  {

	private static final long serialVersionUID = 5606754070227400833L;

	@TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;

	/**
	 * 账号id
	 */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Long userId;
	/**
	 * 职业健康系统的企业id
	 */
	private Long hseCid;
	/**
	 * 企业名称
	 */
	private String name;
	/**
	 * 社会信用代码
	 */
	private String creditCode;
	/**
	 * 所在行政区划
	 */
	private Long areaId;
	/**
	 * 行政区划地址area_id对应的地址 eg：浙江省>杭州市>上城区>笕桥街道>中山路24号
	 */
	private String areaAddress;
	/**
	 * 详细地址
	 */
	private String address;
	/**
	 * 行业
	 */
	private String industryCode;
	/**
	 * 联系人
	 */
	private String contact;
	/**
	 * 联系电话
	 */
	private String contactTel;
	/**
	 * 培训次数/次（来自类型模块）
	 */
	private Integer trainingTimes;
	/**
	 * 注册来源（1-导入、2-单位用户、3-个人用户）
	 */
	private Integer resource;

	/**
	 * 直属企业类型：0-非直属， 1-省直属，2-市属
	 */
	private Integer belongType;

	/**
	 * 营业状态(0-关闭；1-正常；2-暂停营业)
	 */
	private Integer businessState;
}
