package cn.smarthse.radiationTraining.modules.sys.entity.user;

import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Data;

/**
 * 第三方微信信息，由微信登录后获取
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年12月21日 下午4:30:23
 */
@TableName("sys_user_login_weixin")
public @Data class UserLoginWeixin extends BaseBean {

	private static final long serialVersionUID = 2368206902051286825L;

	/**
	 * ID	
	 */
	@TableId(value = "id", type = IdType.AUTO)
	private Long id;
	/**
	 * 用户id
	 */
	private Long userId;
	/**
	 * 注册来源(3：微信登录；4：微信小程序登录)
	 */
    private Integer resource;
	/**
	 * 微信用户的标识，对当前公众号唯一
	 */
	private String openId;
	/**
	 * 用户的昵称
	 */
	private String nickname;
	/**
	 * 用户的性别，值为1时是男性，值为2时是女性，值为0时是未知
	 */
	private String sex;
	/**
	 * 用户所在省份
	 */
	private String province;
	/**
	 * 用户所在城市
	 */
	private String city;
	/**
	 * 用户所在国家
	 */
	private String country;
	/**
	 * 用户的语言，简体中文为zh_CN
	 */
	private String language;
	/**
	 * 用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），用户没有头像时该项为空。若用户更换头像，原有头像URL将失效。
	 */
	private String headimgurl;
	/**
	 * 只有在用户将公众号绑定到微信开放平台帐号后，才会出现该字段。
	 */
	private String unionid;
}
