package cn.smarthse.radiationTraining.modules.sys.entity.user;

import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysUserInfo;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 用户信息
 * </p>
 *
 * @author knight
 * @since 2021-11-23
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("sys_user")
@ApiModel(value = "SysUser对象", description = "用户信息")
public class SysUser extends BaseBean {
	
	private static final long serialVersionUID = -4365937093997566935L;

	@ApiModelProperty("用户id")
	@TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;

	@ApiModelProperty("账号")
	private String username;

	@ApiModelProperty("手机号")
	private String phone;

	@ApiModelProperty("邮箱")
	private String email;

	@ApiModelProperty("盐值")
	private String salt;

	@ApiModelProperty("密码")
	private String password;

	@ApiModelProperty("头像")
	private String avatar;

	@ApiModelProperty("用户名")
	private String name;

	@ApiModelProperty("用户类型(1-个人；2-单位；3-机构；4-医院) SysUserTypeEnum")
	private Integer userType;

	@ApiModelProperty("注册来源（1-注册；2-企业导入；3-单位单点登录创建；4-定时任务创建单位账号;5-培训导入）")
	private Integer resource;

	@ApiModelProperty("行政区划")
	private Long areaId;

	@ApiModelProperty("是否为测试账号（0否 1是）")
	private Integer isTest;

	@ApiModelProperty("是否隐藏,只有省账号可以看(0-否；1-是)")
	private Integer superviseIsHide;

	@ApiModelProperty("是否可以登录会员系统（0否 1是）")
	private Integer hasRegisteredXh;

	@ApiModelProperty("令牌Token（单点登录使用）")
	private Long token;

	@ApiModelProperty("是否禁用（1-禁用；0-启用）")
	private Integer isForbidden;

	@ApiModelProperty("是否改过密码（1-改过；0-没改过）")
	private Integer isChangePwd;

	@ApiModelProperty("是否是默认密码")
	private Boolean isDefaultPwd;

	@ApiModelProperty("密码修改时间")
	private Date pwdUpdateTime;

	@ApiModelProperty("浙里办userId")
	private String zlbUserId;

	@TableField(exist = false)
	private SysUserInfo sysUserInfo;
}
