package cn.smarthse.radiationTraining.modules.sys.entity.sys;


import com.baomidou.mybatisplus.annotation.*;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@TableName("sys_test_pressure1")
@NoArgsConstructor
public class SysTestPressure1 implements Serializable {
    private static final Long serialVersionUID = 5939003209203518031L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 培训名称
     */
    private String trainName;

    /**
     * 培训类型
     */
    private String trainType;

    /**
     * 报名开始时间
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date signStarTime;

    /**
     * 报名结束时间
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date signEndTime;

    /**
     * 培训开始时间
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date trainStarTime;

    /**
     * 培训结束时间
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date trainEndTime;

    /**
     * 封面url
     */
    private String coverUrl;

    /**
     * 是否收费(0-不收费；1-收费)
     */
    private Byte isCharge;

    /**
     * 目标证书Id(certificate.id)
     */
    private Long targetCertificate;

    /**
     * 考试方式(0-分别考试；1-统一考试)
     */
    private Byte testMode;

    /**
     * 试卷使用方式(1-学院共用；2-随机分配)
     */
    private Byte testPaperUsage;

    /**
     * 考试截至时间
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date testEndTime;
    
    /**
     * 重考次数限制(NULL-不限次数)
     */
     private Integer retestLimit;

    /**
     * 重考设置(0-原题重考；1-原题打乱；2-重组试卷)
     */
     private Byte retestSetting;

    /**
     * 状态(0-已下架；1-草稿；2-已上架)
     */
     private Byte status;

    /**
     * 创建时间
     */
     private Date createTime;

    /**
     * 更新时间
     */
     private Date updateTime;

    /**
     * 创建人
     */
     private Long createBy;

    /**
     * 更新人
     */
     private Long updateBy;

    /**
     * 是否有效(0-无效；1-有效)
     */
    @TableLogic
     private Boolean isValid;

    public SysTestPressure1(Long id, String trainName, String coverUrl, Integer retestLimit, Byte retestSetting) {
        this.id = id;
        this.trainName = trainName;
        this.coverUrl = coverUrl;
        this.retestLimit = retestLimit;
        this.retestSetting = retestSetting;
    }

    public Integer getRetestLimit() {
        if (null == retestLimit){
            return -10;
        }else {
            return retestLimit;
        }
    }
}
