package cn.smarthse.radiationTraining.modules.sys.entity.sys;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.Date;

/**
 * @Database: sys_operation_file：url视频及文件配置
 */

@Data
@TableName("sys_operation_file")
public class SysOperationFile implements Serializable{

	private static final Long serialVersionUID = 2328276115780344014L;

    /**
     * id
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 菜单路径
     */
    @Column(name = "url")
    private String url;

    /**
     * 操作文件id,逗号拼接
     */
    @Column(name = "file_ids")
    private String fileIds;

    /**
     * 操作视频id,逗号拼接
     */
    @Column(name = "video_ids")
    private String videoIds;

    /**
     * 系统范围 UserSystemWideEnum
     */
    @Column(name = "system_wide")
    private Integer systemWide;

    /**
     * 备注
     */
    @Column(name = "remarks")
    private String remarks;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 更新者
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 更新时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效
     */
    @Column(name = "is_valid")
    private Boolean isValid;
}
