package cn.smarthse.radiationTraining.modules.sys.entity.sys;

import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;


/**
 * @author <开发者>
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2021-11-11 04:04
 */
@Table(name = "sys_occupational_hazards")
@NoArgsConstructor
public @Data
class SysOccupationalHazards implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     *
     */
    @Id
    @Column(name = "ID")
    private Long id;
    /**
     * pid
     */
    private Long pid;
    /**
     * level
     */
    private Integer level;
    /**
     * 类别：1-粉尘；2-化学因素；3-物理因素；4-放射性因素；5-生物因素；6-其他因素；
     */
    private String type;
    /**
     * 编码
     */
    private String code;
    /**
     * 名称
     */
    private String name;
    /**
     * 别名
     */
    private String alias;
    /**
     * CasNo
     */
    private String casNo;
    /**
     * 拼音首字母
     */
    private String py;
    /**
     * 全拼
     */
    private String fullPy;
    /**
     * 是否高危职业病危害因素：0-否；1-是
     */
    private Boolean isHighRisk;
    /**
     * 是否严重危害因素：0-否；1-是
     */
    private Boolean isSeriousRisk;
    /**
     * 是否GBZ188对应危害
     */
    private Boolean isGbz188Risk;
    /**
     * 是否显示
     */
    private Boolean enableShow;
    /**
     * 标记
     */
    private String remarks;
    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 更新时间
     */
    private Date createDate;
    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 更新时间
     */
    private Date updateDate;
    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    public Boolean getHighRisk() {
        return isHighRisk;
    }

    public Boolean getSeriousRisk() {
        return isSeriousRisk;
    }

    public Boolean getGbz188Risk() {
        return isGbz188Risk;
    }
}